// dcs900.cpp: implementation of the dcs900 class.
////WIFIBOT laurent@wifibot.com
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "../WIFIBOTAPI.h"
#include "dcs900.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

dcs900::dcs900()
{
	VideoRun=false;
	videoproc=false;
	jpegtemp = NULL;
	hdc=0;
	jpegtemp = (BYTE*)calloc( 320*240*3, sizeof( BYTE ) );//Buffer du Jpeg dcompress
}

dcs900::~dcs900()
{
}

void dcs900::init(HWND hwnd,CDC *dc,CString ip,CString p)//Rcupration du "Window Handler" et du "device context" 
{														 //de l'application mre qui cre une instance de la class dcs900		
	hdc=dc;
	myhwnd=hwnd;
	camip=ip;
	port=p;
	rcvok=false;
	imagewidth=0;
	imageheight=0;
}

void dcs900::VideoThread(void)
{
	while(VideoRun)
	{		
		RCVCam();	  //Rception de l'image
		if (videoproc) VideoProc(); //Traitement Video DCS 900 (commenter pour le dsactiver)
		Paint();	 //Affichage dans le GDI de l'application mre	
	}	
}

UINT dcs900::VideoThread(LPVOID p)
{
   dcs900 *me = (dcs900 *)p;
   me->VideoThread();
   return 0;
}	
	
void dcs900::OnVideoOn()
{
	VideoRun=true;
	AfxBeginThread(VideoThread,this);  // Lancement du Thread Video
}

void dcs900::OnVideoOff()
{
	VideoRun=false;
	Sleep(1000);
	closesocket(skSocket);
	skSocket = INVALID_SOCKET;
}

void dcs900::VideoProc()
{
	if (rcvok)
		{
			IplImage image;
			int pixelsize=3;//(24 bits)
			int cxImage    = imagewidth;
			int cyImage    = imageheight;
			int stride     = (cxImage * sizeof( RGBTRIPLE) + 3) & -4;
			cvInitImageHeader( &image, cvSize(cxImage, cyImage), 8, 3, IPL_ORIGIN_BL, 4);
			image.widthStep = stride;
			cvSetImageData( &image, jpegtemp, stride );   
		    // partir d'ici on peut faire ce qu'on veut du buffer image : &image (sous le formmat IPLIMAGE :Voir la doc OpenCV)
			//Le buffer data RGB : "image->imageData"
			
			////////////////////
			////////////////////
			cvThreshold(&image,&image,50,120,0);//Exemple de traitement (Voir Doc ./opencv/doc)
			////////////////////
			////////////////////
		}
}

void dcs900::RCVCam()
{
		HRESULT hr = 0;
		RGBTRIPLE * pData = NULL;
		iTotalSize = 0;

		retval = recv(skSocket,szMessage,sizeof(szMessage),0);
		//printf("retval \n %d ",retval);

		if((retval == 0)||(retval == SOCKET_ERROR))
		{

		char szServerAddress[30];
		char portdcs[10];
		sprintf_s(szServerAddress,"%s",camip);
		sprintf_s(portdcs,"%s",port);
		int iPort=atoi(portdcs);
		
		struct		sockaddr_in serv_addr;
		LPHOSTENT	lphost;
		WSADATA wsaData;
		WORD	wVersionRequested;
		int		iStatus;
		int	 iBytesSent = 0;			// # of Bytes Sent

		rcvok=false;
		wVersionRequested = MAKEWORD( 2, 0 );
		skSocket = INVALID_SOCKET;
		iStatus = WSAStartup(wVersionRequested,&wsaData);

		memset(&serv_addr,0,sizeof(sockaddr_in));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = inet_addr (szServerAddress);

		if (serv_addr.sin_addr.s_addr == INADDR_NONE)
		{
		lphost = gethostbyname(szServerAddress);
		if (lphost != NULL)
		serv_addr.sin_addr.s_addr = ((LPIN_ADDR)lphost->h_addr)->s_addr;
		else
		{
		WSASetLastError(WSAEINVAL);
		}
		}

		serv_addr.sin_port = htons(iPort);

		// Open the socket
		skSocket = socket(AF_INET, SOCK_STREAM, 0);

		int err = connect(skSocket, (struct sockaddr*)&serv_addr,sizeof(sockaddr));
		if(err == SOCKET_ERROR)
		{ 
		if(skSocket != INVALID_SOCKET)
		{
		closesocket(skSocket);
		skSocket = INVALID_SOCKET;
		}
		}
		// Populate the data packet
		strcpy(DataPacket, "GET /VIDEO.CGI HTTP/1.0\r\nUser-Agent: \r\nAuthorization: Basic \r\n\r\n");
		iBytesSent = send(skSocket,DataPacket,128,0);
		}//end of if
		else 
		{  
		ZeroMemory(szCompleteImage,200000);
		memcpy(szAux,szMessage,15);
		   
		if(!strcmp(szAux,"Content-Length:"))//we continue only if we are at the beginning of a new image
		{
		memcpy(szCompleteImage,szMessage,retval);
		iTotalSize = retval;
		   
		while((strcmp(szAux,"video boundary:")!=0)&&(retval!=0)&&(retval!=SOCKET_ERROR))   
		{
			retval = recv(skSocket,szMessage,sizeof(szMessage),0);
			memcpy(szCompleteImage+iTotalSize,szMessage,retval);
			iTotalSize = iTotalSize + retval;
			memcpy(szAux,szMessage+(retval-18),14);
		}
		  
		if(!strcmp(szAux,"video boundary:"))	
		{
			ijlInit(&jpeg);
			jpeg.JPGFile = NULL;
			jpeg.JPGBytes=(unsigned char*)szCompleteImage;
			jpeg.JPGSizeBytes=iTotalSize;
		  
			ijlRead(&jpeg, IJL_JBUFF_READPARAMS);
		   
			jpeg.JPGColor = IJL_YCBCR;
		   
			// Set up the info on the desired DIB properties.
			jpeg.DIBColor = IJL_BGR;
			jpeg.DIBChannels = 3;
			jpeg.DIBWidth = jpeg.JPGWidth;
			jpeg.DIBHeight = -jpeg.JPGHeight;
			jpeg.DIBPadBytes = 0;
			jpeg.DIBBytes = jpegtemp;

			// Now get the actual JPEG image data into the pixel buffer.
			ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE);
			rcvok=true;
			imagewidth=jpeg.JPGWidth;
			imageheight=jpeg.JPGHeight;
 
			ijlFree(&jpeg);
   }
  }//end of if
}//end if
	
		}

void dcs900::Paint()
{
				///////////////////////////////////////////////
				//////////////////////////////////////////////
				float Xdest=0,Ydest=0;
				bi.bmiHeader.biSize        = sizeof( BITMAPINFOHEADER );
                bi.bmiHeader.biWidth       = jpeg.JPGWidth;
                bi.bmiHeader.biHeight      = jpeg.JPGHeight;
                bi.bmiHeader.biCompression = BI_RGB;
                bi.bmiHeader.biPlanes      = 1;
                bi.bmiHeader.biBitCount    = 24;

				// Now calculate stretch factor
				RECT rc;
				// Make the preview video fill our window
				GetClientRect(myhwnd,&rc);

				//Xdest=(float)(rc.right*(41.0/736.0));
				//Ydest=(float)(rc.bottom*(54.0/444.0));
		    	Xdest=0.1*rc.right;
	            Ydest=0.2*rc.bottom;
				float x_stretch = (float) 320 / jpeg.JPGWidth;
                float y_stretch = (float) 240 / jpeg.JPGHeight;
                float stretch;
                if ( x_stretch < 1 || y_stretch < 1 )
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
                else
                    stretch = x_stretch < y_stretch ? x_stretch : y_stretch;
					SetStretchBltMode( hdc->m_hDC, COLORONCOLOR );
					StretchDIBits( hdc->m_hDC,
                               (long)Xdest,
							   (long)Ydest,
							   (int)(jpeg.JPGWidth * rc.right *(1.42/736.0)),              //DestHeight 1.5
							   (int)(jpeg.JPGHeight * rc.bottom*(1.34/444.0)),             //DestWidth 1.5
                               //(long)0.92*rc.bottom,
       						   //(long)0.715*rc.right,
 							   0, 0,                                            //XSrc, YSrc
                               jpeg.JPGWidth,jpeg.JPGHeight,       //SrcHeight, SrcWidth
                               jpegtemp,
                               &bi,
                               DIB_RGB_COLORS,
                               SRCCOPY );
					///////////////////////////////////////////////
					//////////////////////////////////////////////    
}

